## Introduction to ACP
- Access control is hierarchical and policy-based, allowing specification, inspection, and logging of network traffic.
- Each Cisco Secure Firewall Threat Defense device is assigned one ACP.
## Key Functions of ACP
- **Traffic Control**: Allows or blocks traffic based on characteristics.
- **Advanced Analysis**: Sends traffic to IPS or file policy for malicious inspection.
- **Logging**: Decides if traffic should be logged as connection events.
- **Advanced Settings Management**: Manages security intelligence, SSL decryption, authentication, and more.
## ACP Structure
- **Rule Processing**: Top-down, first match approach.
- **Monitor Action Exception**: Only logs traffic, allowing continued rule matching.
## ACP Components
- **Rules**: Match traffic conditions in a top-down fashion.
- **Prefilter Policy**: Fastpaths or drops traffic before inspection.
- **Default Action**: Applied to unmatched traffic.
- **Security Intelligence**: Filters traffic based on IP, URL, and DNS reputation.

## ACP Rules

### Rule Components

- **Name**: Unique identifier for the rule.
- **Conditions**: Identify traffic type, requiring all conditions to match.
- **Action**: Specifies the outcome for matched traffic (allow, block, analyze).
- **Inspection Settings**: Determines if traffic will be analyzed by IPS or file policy.
- **Logging Settings**: Controls logging of connection events.

### Conditions for ACP

- **Zones**: Matches traffic entering/leaving via specific security zones.
- **OSI Layers 2-4**: Matches based on VLAN, IP addresses, protocols, ports.
- **OSI Layer 7**: Matches based on applications and URLs.
- **Miscellaneous**: Matches based on user identity, Cisco ISE attributes.

## Ports vs. Applications

- **Port Matching**: Efficient but may misidentify traffic on non-native ports.
- **Application Matching**: Accurate for applications but requires Snort processing.

## ACP Rule Actions

### Available Actions

- **Allow**: Permits traffic, potentially for further inspection.
- **Trust**: Permits traffic without further inspection.
- **Block/Block with Reset**: Denies traffic, resets connections.
- **Interactive Block**: Provides custom HTTP response pages for blocked traffic.
- **Monitor**: Logs traffic without affecting flow.

### Default Action

- Specifies treatment for unmatched traffic, considering security intelligence and prefilter policy.

## ACP Further Inspections

- **IPS Policy**: Uses Snort rules to detect threats.
- **File Policy**: Detects and blocks certain file types or malware.

## ACP Logging

### Logging Configuration

- Specifies logging at connection start or end.
- Determines logging destination.

### Connection Events

- Contain data about monitored connections, including basic properties, additional discoveries, and metadata.

## ACP Use Case Example

### Configuration Scenario

1. **Telnet Block**: Blocks Telnet traffic from inside to outside zones.
2. **Social Networking Block**: Blocks access to social networking sites.
3. **Internet Access**: Allows other outbound Internet traffic.
4. **DMZ Server Access**: Allows specific services from outside to DMZ server.
5. **Internal DMZ Access**: Allows internal access to DMZ services.

- **Default Action**: Blocks all other communication.